/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery.os;

import com.wilibox.discovery.os.NetshFirewallRule;
import com.wilibox.discovery.os.NetshParser;
import com.wilibox.discovery.os.Shell;
import com.wilibox.discovery.os.ShellException;
import com.wilibox.discovery.os.ShellResult;
import java.io.File;
import java.io.IOException;

public class WindowsShell
extends Shell {
    private static final String SHELL_CMD = "cmd /C \"{0}\"";
    private static final String ARP_ADD_CMD = "arp -s {0} {1} {2}";
    private static final String ARP_DEL_CMD = "arp -d {0}";
    private static final String PING_CMD = "ping {0} -l {1} -n {2} -w {3}";
    private Process currentProcess;

    public static ShellResult execute(String cmd) throws IOException, ShellException {
        ShellResult result = Shell.execute("cmd", "/C", cmd);
        return result;
    }

    public static Process start(String cmd) throws ShellException {
        return Shell.start("cmd", "/C", cmd);
    }

    private static boolean hasFirewallRule(String name) throws IOException, ShellException {
        String cmd = WindowsShell.format("netsh advfirewall firewall show rule name=\"{0}\"", name);
        ShellResult result = WindowsShell.execute(cmd);
        String output = result.getOutput();
        NetshFirewallRule[] rules = NetshParser.parseRulesView(output);
        return rules.length > 0;
    }

    private static void addFirewallRule(String name, String description, String path) throws IOException, ShellException {
        String cmd = WindowsShell.format("netsh advfirewall firewall add rule name=\"{0}\" dir=in action=allow profile=any description=\"{1}\" program=\"{2}\"", name, description, path);
        WindowsShell.execute(cmd);
    }

    private static void delFirewallRule(String name) throws IOException, ShellException {
        String cmd = WindowsShell.format("netsh advfirewall firewall delete rule name=\"{0}\"", name);
        ShellResult result = WindowsShell.execute(cmd);
    }

    public static void updateFirewallRules() throws IOException, ShellException {
        if (WindowsShell.hasFirewallRule("Java(TM) Platform SE binary")) {
            WindowsShell.delFirewallRule("Java(TM) Platform SE binary");
        }
        File jreJavaw = new File(new File(new File(System.getProperty("java.home")), "bin"), "javaw.exe");
        File jreJava = new File(new File(new File(System.getProperty("java.home")), "bin"), "java.exe");
        File winJavaw = new File("C:\\windows\\system32\\javaw.exe");
        File winJava = new File("C:\\windows\\system32\\java.exe");
        if (jreJavaw.exists()) {
            WindowsShell.addFirewallRule("Java(TM) Platform SE binary", "Java(TM) Platform SE binary", jreJavaw.toString());
        }
        if (jreJava.exists()) {
            WindowsShell.addFirewallRule("Java(TM) Platform SE binary", "Java(TM) Platform SE binary", jreJava.toString());
        }
        if (winJavaw.exists()) {
            WindowsShell.addFirewallRule("Java(TM) Platform SE binary", "Java(TM) Platform SE binary", winJavaw.toString());
        }
        if (winJava.exists()) {
            WindowsShell.addFirewallRule("Java(TM) Platform SE binary", "Java(TM) Platform SE binary", winJava.toString());
        }
    }

    private static void clearArpCache() throws IOException, ShellException {
        WindowsShell.execute("netsh interface ip delete arpcache");
    }

    private static void addArp(String ip, String mac, String iface) throws IOException, ShellException {
        Object[] args = new Object[]{ip, mac, iface};
        String cmd = WindowsShell.format(ARP_ADD_CMD, args);
        WindowsShell.execute(cmd);
    }

    private static void delArp(String ip) throws IOException, ShellException {
        Object[] args = new Object[]{ip};
        String cmd = WindowsShell.format(ARP_DEL_CMD, args);
        WindowsShell.execute(cmd);
    }

    private static Process ping(String ip, int timeout) throws IOException, ShellException {
        Object[] args = new Object[]{ip, 369, timeout, 1000};
        String cmd = WindowsShell.format(PING_CMD, args);
        return WindowsShell.start(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetStart(String mac, String iface, int timeout) throws IOException, ShellException {
        int result;
        if (this.currentProcess != null) {
            return -1;
        }
        WindowsShell.delArp("192.168.2.66");
        try {
            WindowsShell.addArp("192.168.2.66", mac, iface);
            this.currentProcess = WindowsShell.ping("192.168.2.66", timeout);
            result = WindowsShell.wait(this.currentProcess);
        }
        finally {
            WindowsShell.delArp("192.168.2.66");
            WindowsShell.clearArpCache();
        }
        return result;
    }

    public void resetAbort() {
        if (this.currentProcess == null) {
            return;
        }
        this.currentProcess.destroy();
        this.currentProcess = null;
    }
}

