/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.AddAction;
import com.wilibox.discovery.BinUtils;
import com.wilibox.discovery.CloseAction;
import com.wilibox.discovery.Device;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.Main;
import com.wilibox.discovery.SocketInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;

public class NewDeviceDialog
extends JDialog {
    private Main parent;
    JButton addButton;
    JButton closeButton;
    JFormattedTextField macField;
    JComboBox ifaceField;
    JLabel macLabel;
    JLabel ifaceLabel;
    JLabel ifaceNameLabel;
    SocketInfo[] ifaces;

    public NewDeviceDialog(Main parent) {
        super(parent, LanguageFactory.get_text("newdlg-caption", new String[0]), true);
        this.parent = parent;
        this.setSize(new Dimension(500, 200));
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("HH-HH-HH-HH-HH-HH");
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
        }
        this.macField = new JFormattedTextField(formatter);
        this.macField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.doit(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.doit(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.doit(e);
            }

            private void doit(DocumentEvent e) {
                String s = NewDeviceDialog.this.macField.getText();
                if (s.indexOf(" ") != -1) {
                    NewDeviceDialog.this.addButton.setEnabled(false);
                } else {
                    NewDeviceDialog.this.addButton.setEnabled(true);
                }
            }
        });
        this.macField.setPreferredSize(new Dimension(150, 25));
        this.ifaces = parent.getInterfaces();
        String[] line = new String[this.ifaces.length];
        for (int i = 0; i < this.ifaces.length; ++i) {
            line[i] = this.ifaces[i].getInterfaceMac() == null ? String.format("%s - %s (%s)", this.ifaces[i].getInterface(), this.ifaces[i].getInterfaceIP(), LanguageFactory.get_text("newdlg-macstatus", new String[0])) : String.format("%s - %s (%s)", this.ifaces[i].getInterface(), this.ifaces[i].getInterfaceIP(), BinUtils.arr_to_mac(this.ifaces[i].getInterfaceMac()));
        }
        this.ifaceField = new JComboBox<String>(line);
        this.ifaceField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int index = cb.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                NewDeviceDialog.this.ifaceNameLabel.setText(LanguageFactory.get_text("newdlg-selected", NewDeviceDialog.this.ifaces[index].getInterfaceName()));
            }
        });
        this.ifaceField.setPreferredSize(new Dimension(300, 25));
        this.macLabel = new JLabel(LanguageFactory.get_text("newdlg-mac", new String[0]));
        this.ifaceLabel = new JLabel(LanguageFactory.get_text("newdlg-interface", new String[0]));
        this.ifaceNameLabel = new JLabel(LanguageFactory.get_text("newdlg-interface", new String[0]));
        this.ifaceNameLabel.setPreferredSize(new Dimension(370, 25));
        if (this.ifaces.length > 0) {
            this.ifaceNameLabel.setText(LanguageFactory.get_text("newdlg-selected", this.ifaces[0].getInterfaceName()));
        }
        this.addButton = new JButton(new AddAction(this));
        this.closeButton = new JButton(new CloseAction(this));
        JPanel btnsPanel = new JPanel(new FlowLayout());
        btnsPanel.add(this.addButton);
        btnsPanel.add(this.closeButton);
        JPanel bodyPanel = new JPanel();
        bodyPanel.setLayout(new GridBagLayout());
        this.addItem(bodyPanel, this.macLabel, 0, 0, 1, 1, 13);
        this.addItem(bodyPanel, this.ifaceLabel, 0, 1, 1, 1, 13);
        this.addItem(bodyPanel, this.macField, 1, 0, 2, 1, 17);
        this.addItem(bodyPanel, this.ifaceField, 1, 1, 2, 1, 17);
        this.addItem(bodyPanel, this.ifaceNameLabel, 0, 2, 3, 1, 17);
        this.addItem(bodyPanel, btnsPanel, 0, 4, 3, 1, 10);
        this.getContentPane().add((Component)bodyPanel, "Center");
    }

    private void addItem(JPanel p, JComponent c, int x, int y, int width, int height, int align) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.gridheight = height;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.anchor = align;
        gc.fill = 0;
        p.add((Component)c, gc);
    }

    public void addDevice() {
        int index = this.ifaceField.getSelectedIndex();
        Device d = new Device(this.macField.getText(), null, "", "", this.ifaces[index]);
        this.parent.addDevice(d);
    }

    public void clean() {
        this.macField.setText("");
    }
}

