/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.ResetAction;
import com.wilibox.discovery.ResetActionHandler;

class MulticastResetAction
extends ResetAction {
    private ResetActionHandler parent;
    private Device reset_device;
    private int state_counter;
    private static final int ST_UNKNOWN = 0;
    private static final int ST_BOOTED = 1;
    private static final int ST_BOOTING = 3;
    private static final int ST_EXTENDED = 7;
    private static final int ST_RESETING = 15;
    private static final int ST_RESETED = 31;
    private static final int ST_READY = 63;
    private static final int ST_USERSTOP = 65535;

    private String strState(int state) {
        switch (state) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Booted";
            }
            case 3: {
                return "Booting";
            }
            case 7: {
                return "Extended";
            }
            case 15: {
                return "Reseting";
            }
            case 31: {
                return "Reseted";
            }
            case 63: {
                return "Ready";
            }
            case 65535: {
                return "UserStop";
            }
        }
        return "";
    }

    public MulticastResetAction(ResetActionHandler parent, Device reset_device) {
        this.parent = parent;
        this.reset_device = reset_device;
    }

    public void deviceBootState(String mac) {
        this.state_counter = this.state_counter == 15 ? (this.state_counter |= 0x1F) : (this.state_counter |= 3);
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceWorkState(String mac) {
        this.state_counter = this.state_counter == 31 ? (this.state_counter |= 0x3F) : (this.state_counter |= 1);
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceExtended(String mac) {
        this.state_counter |= 7;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceReseting(String mac) {
        this.state_counter |= 0xF;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        this.state_counter = 0;
        String device_mac = this.reset_device.getMacAddress();
        this.mcast_reset(device_mac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcast_reset(String devMac) {
        try {
            this.parent.setStatus(LanguageFactory.get_text("status-devstate", new String[0]));
            this.parent.setHint("");
            while (this.state_counter < 1) {
                this.parent.getResetHolder().send_state(devMac);
                this.sleep(1000);
            }
            this.parent.setStatus(LanguageFactory.get_text("status-waiting", new String[0]));
            this.parent.setHint(LanguageFactory.get_text("reset-hint-onoff", new String[0]));
            int counter = 0;
            while (this.state_counter < 3) {
                this.sleep(1000);
                if (counter > 300) {
                    this.parent.reset_finish(LanguageFactory.get_text("status-timeout", new String[0]), "");
                    return;
                }
                ++counter;
            }
            this.parent.setStatus(LanguageFactory.get_text("status-extending", new String[0]));
            this.parent.setHint("");
            counter = 0;
            while (this.state_counter < 7) {
                this.sleep(1000);
                if (counter > 5) {
                    this.parent.setHint(LanguageFactory.get_text("reset-hint-onoff-again", new String[0]));
                }
                ++counter;
            }
            this.parent.setStatus(LanguageFactory.get_text("status-reseting", new String[0]));
            this.parent.setHint("");
            counter = 0;
            while (this.state_counter < 15) {
                this.parent.getResetHolder().send_reset(devMac);
                this.sleep(1000);
                if (counter > 5) {
                    this.parent.setHint(LanguageFactory.get_text("reset-hint-onoff-again", new String[0]));
                }
                ++counter;
            }
            this.parent.getResetHolder().set_autoextend(false);
            while (this.state_counter < 31) {
                this.sleep(1000);
            }
            this.parent.getResetHolder().send_boot(devMac);
            this.parent.setStatus(LanguageFactory.get_text("status-booting", new String[0]));
            this.parent.setHint("");
            counter = 0;
            while (this.state_counter < 63) {
                this.sleep(1000);
                if (counter > 30) {
                    this.parent.reset_finish(LanguageFactory.get_text("status-timeout", new String[0]), "");
                    return;
                }
                ++counter;
            }
            this.parent.reset_finish(LanguageFactory.get_text("status-complete", new String[0]), "");
        }
        catch (Exception ex) {
            if (this.parent.is_verbose()) {
                ex.printStackTrace();
            }
            this.parent.reset_finish(LanguageFactory.get_text("status-failed", new String[0]), ex.getMessage());
        }
        finally {
            this.parent.getResetHolder().set_autoextend(true);
        }
    }

    public void stop() {
        this.state_counter = 65535;
    }

    public boolean is_canceled() {
        return this.state_counter == 65535;
    }
}

