/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.OShell;
import com.wilibox.discovery.SocketContext;
import com.wilibox.discovery.SocketInfo;
import com.wilibox.discovery.os.LinuxShell;
import com.wilibox.discovery.os.MacShell;
import com.wilibox.discovery.os.Shell;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastQueryServer {
    private static final Logger logger = Logger.getLogger(MulticastQueryServer.class.getName());
    private static final int MCAST_TTL = 1;
    private static final int MCAST_TIMEOUT = 100;
    private static boolean verbose = false;
    private ArrayList<SocketContext> socketList = new ArrayList();
    private byte[] mcast_group = null;
    private int mcast_port = -1;

    public MulticastQueryServer(byte[] mcast_group, int mcast_port) {
        this.mcast_group = mcast_group;
        this.mcast_port = mcast_port;
    }

    public void setVerbose() {
        verbose = true;
        logger.setLevel(Level.ALL);
    }

    public int create_sockets() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            System.out.println("Failed to retrieve network interfaces list" + ex);
            return 2;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            try {
                if (!iface.isUp()) {
                    if (!verbose) continue;
                    System.out.println(String.format("Skipping inactive interface %s", iface.getName()));
                    continue;
                }
            }
            catch (SocketException e) {
                System.out.println(String.format("Interface %s upstate check failed", iface.getName()));
            }
            if (MulticastQueryServer.isLoopback(iface)) {
                if (!verbose) continue;
                System.out.println(String.format("Skipping loopback %s", iface.getName()));
                continue;
            }
            if (OShell.is_linux() || OShell.is_windows_xp()) {
                this.create_mcast_linux_winnt(iface);
                continue;
            }
            if (OShell.is_windows_7() || OShell.is_macos()) {
                this.create_mcast_winv7_mac(iface);
                continue;
            }
            this.create_mcast_linux_winnt(iface);
        }
        if (this.socketList.size() > 0) {
            return 0;
        }
        System.out.println("No multicast sockets were opened");
        return -1;
    }

    public int create_mcast_linux_winnt(NetworkInterface iface) {
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        InetAddress inetAddress = null;
        if (addresses.hasMoreElements()) {
            inetAddress = addresses.nextElement();
        }
        try {
            InetAddress mcast_address = InetAddress.getByAddress(this.mcast_group);
            MulticastSocket socket = new MulticastSocket(this.mcast_port);
            socket.setNetworkInterface(iface);
            socket.joinGroup(new InetSocketAddress(mcast_address, this.mcast_port), iface);
            socket.setSoTimeout(100);
            socket.setTimeToLive(1);
            socket.setLoopbackMode(true);
            SocketContext sock = new SocketContext(socket, iface, inetAddress, this.mcast_port);
            this.socketList.add(sock);
            if (verbose) {
                System.out.println(String.format("Creating socket %s (%s:%s)", iface.getName(), inetAddress.getHostAddress(), this.mcast_port));
            }
        }
        catch (IOException ex) {
            System.out.println(String.format("Failed to Opening socket on %s. ", iface.getName()) + ex);
            return -1;
        }
        return 0;
    }

    public int create_mcast_winv7_mac(NetworkInterface iface) {
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        if (addresses.hasMoreElements()) {
            InetAddress inetAddress = addresses.nextElement();
            try {
                MulticastSocket socket = new MulticastSocket(this.mcast_port);
                socket.setInterface(inetAddress);
                socket.joinGroup(new InetSocketAddress(InetAddress.getByAddress(this.mcast_group), this.mcast_port), iface);
                socket.setSoTimeout(100);
                socket.setTimeToLive(1);
                socket.setLoopbackMode(true);
                SocketContext sock = new SocketContext(socket, iface, inetAddress, this.mcast_port);
                this.socketList.add(sock);
                if (verbose) {
                    System.out.println(String.format("Creating socket %s (%s:%s)", iface.getName(), inetAddress.getHostAddress(), this.mcast_port));
                }
            }
            catch (IOException ex) {
                System.out.println(String.format("Failed to Opening socket on %s. ", iface.getName()) + ex);
                return -1;
            }
        }
        return 0;
    }

    public int create_legacy_sockets() {
        Enumeration<NetworkInterface> interfaces;
        int rp_all = -1;
        int rp_iface = -1;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            System.out.println("Failed to retrieve network interfaces list, " + ex);
            return 2;
        }
        boolean i = false;
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            try {
                if (!iface.isUp()) {
                    if (!verbose) continue;
                    System.out.println(String.format("Skipping inactive interface %s", iface.getName()));
                    continue;
                }
            }
            catch (SocketException e) {
                System.out.println(String.format("Interface %s upstate check failed", iface.getName()));
            }
            if (MulticastQueryServer.isLoopback(iface)) {
                if (!verbose) continue;
                System.out.println(String.format("Skipping loopback %s", iface.getName()));
                continue;
            }
            if (Shell.isLinux()) {
                rp_all = LinuxShell.getRPF("all");
                rp_iface = LinuxShell.getRPF(iface.getName());
                LinuxShell.setRPF(iface.getName(), 0);
            }
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                try {
                    InetSocketAddress saddr = new InetSocketAddress(inetAddress, this.mcast_port);
                    MulticastSocket socket = new MulticastSocket(saddr);
                    socket.setInterface(inetAddress);
                    if (!OShell.is_macos()) {
                        socket.setNetworkInterface(iface);
                    }
                    socket.joinGroup(InetAddress.getByAddress(this.mcast_group));
                    socket.setSoTimeout(100);
                    socket.setTimeToLive(1);
                    socket.setLoopbackMode(true);
                    SocketContext sock = null;
                    sock = Shell.isLinux() ? new SocketContext(socket, iface, inetAddress, this.mcast_port, rp_iface, rp_all) : new SocketContext(socket, iface, inetAddress, this.mcast_port);
                    this.socketList.add(sock);
                    if (!verbose) continue;
                    System.out.println(String.format("Creating socket %s (%s:%s)", iface.getName(), inetAddress.getHostAddress(), this.mcast_port));
                }
                catch (IOException ex) {
                    System.out.println(String.format("Failed to Opening socket on %s. ", iface.getName()) + ex);
                }
            }
        }
        if (Shell.isLinux()) {
            LinuxShell.setRPF("all", 0);
        }
        if (this.socketList.size() > 0) {
            return 0;
        }
        System.out.println("No multicast sockets were opened");
        return -1;
    }

    public void close_sockets() {
        for (SocketContext socket_ctx : this.socketList) {
            try {
                if (Shell.isLinux()) {
                    LinuxShell.setRPF(socket_ctx.get_interface_name(), socket_ctx.get_rp_iface());
                    LinuxShell.setRPF("all", socket_ctx.get_rp_all());
                    continue;
                }
                if (!Shell.isMacos()) continue;
                MacShell.setSkipOn(socket_ctx.get_interface_name());
            }
            catch (Exception ex) {
                if (!verbose) continue;
                System.out.println("Unable to enable reverse path finder: " + ex);
            }
        }
        this.socketList.clear();
    }

    public byte[] get_mac() {
        for (SocketContext socket_ctx : this.socketList) {
            try {
                NetworkInterface iface = socket_ctx.get_interface();
                return iface.getHardwareAddress();
            }
            catch (SocketException e) {
                System.out.println("Failed to retrieve mac, " + e);
            }
        }
        return null;
    }

    public int read_socket(DatagramPacket p, MulticastSocket sock) {
        try {
            sock.receive(p);
        }
        catch (SocketTimeoutException ex) {
            return 1;
        }
        catch (IOException e) {
            System.out.println("Failure reading socket, " + e);
            return -1;
        }
        return 0;
    }

    public int write_socket(DatagramPacket p, MulticastSocket sock) {
        try {
            sock.send(p);
        }
        catch (IOException e) {
            System.out.println("Failure writing socket, " + e);
            return -1;
        }
        return 0;
    }

    public int read_sockets(DatagramPacket p, SocketInfo s) {
        int nodata = 1;
        for (SocketContext socket_ctx : this.socketList) {
            MulticastSocket sock = socket_ctx.get_socket();
            if ((nodata &= this.read_socket(p, sock)) != 0) continue;
            socket_ctx.fill(s);
            break;
        }
        return nodata;
    }

    public int write_sockets(DatagramPacket p) {
        int nodata = 1;
        for (SocketContext socket_ctx : this.socketList) {
            MulticastSocket sock = socket_ctx.get_socket();
            nodata &= this.write_socket(p, sock);
        }
        return nodata;
    }

    private static boolean isLoopback(NetworkInterface iface) {
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress inetAddress = addresses.nextElement();
            if (!inetAddress.isLoopbackAddress()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return false;
        }
        return true;
    }

    public static SocketInfo[] get_interfaces() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<SocketInfo> if_list = new ArrayList<SocketInfo>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            logger.log(Level.SEVERE, "Failed to retrieve list of available netwok interfaces", ex);
            Object[] arr = if_list.toArray();
            return (SocketInfo[])arr;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            try {
                if (!iface.isUp()) {
                    if (!verbose) continue;
                    System.out.println(String.format("Skipping inactive interface %s", iface.getName()));
                    continue;
                }
            }
            catch (SocketException e) {
                System.out.println(String.format("Interface %s upstate check failed", iface.getName()));
            }
            if (MulticastQueryServer.isLoopback(iface)) {
                if (!verbose) continue;
                System.out.println(String.format("Skipping loopback %s", iface.getName()));
                continue;
            }
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            InetAddress inetAddress = null;
            if (addresses.hasMoreElements()) {
                inetAddress = addresses.nextElement();
            }
            if (inetAddress == null) {
                System.out.println(String.format("Skipping interface %s with ip not set", iface.getName()));
                continue;
            }
            byte[] mac_addr = new byte[6];
            try {
                mac_addr = iface.getHardwareAddress();
            }
            catch (SocketException ex) {
                System.out.println(String.format("Failed to get\tMAC from %s", iface.getName()));
            }
            SocketInfo sinfo = new SocketInfo(iface.getName(), iface.getDisplayName(), mac_addr, inetAddress.getHostAddress());
            if_list.add(sinfo);
        }
        SocketInfo[] arr = new SocketInfo[if_list.size()];
        for (int i = 0; i < if_list.size(); ++i) {
            arr[i] = (SocketInfo)if_list.get(i);
        }
        return arr;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

