/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.DeviceTableModel;
import com.wilibox.discovery.DiscoveryActionHandler;
import com.wilibox.discovery.DiscoveryProto;
import com.wilibox.discovery.DiscoveryProtoListener;
import com.wilibox.discovery.ExitAction;
import com.wilibox.discovery.GetOpt;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.LegacyProto;
import com.wilibox.discovery.MulticastQueryServer;
import com.wilibox.discovery.NewDeviceDialog;
import com.wilibox.discovery.ProtocolException;
import com.wilibox.discovery.ResetActionHandler;
import com.wilibox.discovery.SocketInfo;
import com.wilibox.discovery.StatusBar;
import com.wilibox.discovery.os.Shell;
import com.wilibox.discovery.os.WindowsShell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class Main
extends JFrame
implements TableModelListener,
ListSelectionListener,
DiscoveryProtoListener {
    private DiscoveryProto discovery;
    private LegacyProto legacy;
    public static final String KEY_BROWSER = "browser.cmdline";
    private static final String[] WIN32_BROWSER;
    private static final String[] LINUX_BROWSER;
    private static final String[] MACOSX_BROWSER;
    private static final int EXTTIME_1 = 30;
    private static final int EXTTIME_2 = 60;
    private static LinkedList<Device> dList;
    String ext_mac = null;
    static int index;
    static int selectedIndex;
    static boolean silent;
    private static boolean verbose;
    Main self;
    Properties props;
    JTable table;
    JButton discoveryButton;
    JButton clearButton;
    JButton resetButton;
    JButton addButton;
    JPopupMenu popupMenu;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu helpMenu;
    JMenuItem exitMenuItem;
    JMenuItem aboutMenuItem;
    JMenuItem noteMenuItem;
    JMenu localeMenu;
    JMenuItem language_en;
    JMenuItem language_br;
    StatusBar statusBar;
    DeviceTableModel model;

    private static File get_launcher() {
        File launcher_path = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return launcher_path;
    }

    public Main(Properties props, int verbosity, LegacyProto discoveryHolder, DiscoveryProto resetHolder) {
        super(props.getProperty("caption"));
        this.legacy = discoveryHolder;
        this.discovery = resetHolder;
        verbose = verbosity != 0;
        this.self = this;
        this.props = props;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL imageURL = classLoader.getResource("images/icon.png");
        if (imageURL != null) {
            this.setIconImage(new ImageIcon(imageURL).getImage());
        } else {
            System.out.println("Image file not found");
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.createComponents();
        this.layoutComponents();
        this.pack();
        this.setSize(900, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Main.this.getDiscoveryHolder().getServer().close_sockets();
                System.exit(0);
            }
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public DiscoveryProto getResetHolder() {
        return this.discovery;
    }

    public LegacyProto getDiscoveryHolder() {
        return this.legacy;
    }

    private void renewTitles() {
        this.discoveryButton.setText(LanguageFactory.get_text("button-scan", new String[0]));
        this.clearButton.setText(LanguageFactory.get_text("button-clear", new String[0]));
        this.resetButton.setText(LanguageFactory.get_text("button-reset", new String[0]));
        this.addButton.setText(LanguageFactory.get_text("button-add", new String[0]));
        this.fileMenu.setText(LanguageFactory.get_text("menu-file", new String[0]));
        this.helpMenu.setText(LanguageFactory.get_text("menu-help", new String[0]));
        this.localeMenu.setText(LanguageFactory.get_text("menu-language", new String[0]));
        this.exitMenuItem.setText(LanguageFactory.get_text("menu-exit", new String[0]));
        this.aboutMenuItem.setText(LanguageFactory.get_text("menu-about", this.props.getProperty("caption")));
        this.noteMenuItem.setText(LanguageFactory.get_text("menu-readme", new String[0]));
        this.setStatus("");
        this.setHint("");
        this.setDevice("");
        this.model.refreshTitles();
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col = this.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(80);
        col = this.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(500);
        col = this.table.getColumnModel().getColumn(3);
        col.setPreferredWidth(20);
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }

    public void setIndex(int idx) {
        index = idx;
    }

    public int getIndex() {
        return index;
    }

    public Device getDevice(int index) {
        if (index >= dList.size()) {
            return null;
        }
        return dList.get(index);
    }

    public SocketInfo[] getInterfaces() {
        SocketInfo[] info = MulticastQueryServer.get_interfaces();
        return info;
    }

    public int addDevice(Device dev) {
        dList.addLast(dev);
        this.model.addRow(dev);
        return 0;
    }

    public void clearDevices() {
        dList.clear();
        this.model.setRowCount(0);
        this.table.clearSelection();
    }

    public void deviceFound(Device dev) {
        int x = -1;
        for (int i = 0; i < dList.size(); ++i) {
            Device d = dList.get(i);
            String mac = d.getMacAddress();
            if (!mac.equals(dev.getMacAddress())) continue;
            x = i;
            break;
        }
        if (x == -1) {
            dList.addLast(dev);
        }
    }

    public void deviceBootState(String mac) {
    }

    public void deviceWorkState(String mac) {
    }

    public void deviceExtended(final String mac) {
        if (index > 0 || !this.getResetHolder().get_autoextend() || silent) {
            return;
        }
        index = this.getResetHolder().get_proto_ver() == 2 ? 60 : 30;
        this.ext_mac = mac;
        Thread thr = new Thread(new Runnable(){

            public void run() {
                while (index > 0) {
                    Main.this.setStatus(LanguageFactory.get_text("status-extended", new String[0]));
                    Main.this.setDevice(LanguageFactory.get_text("notify-device", mac));
                    Main.this.setHint(LanguageFactory.get_text("notify-boot", Integer.toString(index)));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --index;
                }
                Main.this.setStatus("");
                Main.this.setHint("");
                Main.this.setDevice("");
            }
        });
        thr.start();
    }

    public void deviceReseting(String mac) {
        index = 0;
    }

    public void deviceMarked(String mac) {
    }

    public void deviceWrongPin(String mac) {
    }

    public void tableChanged(TableModelEvent e) {
        int cnt = this.table.getRowCount();
        int row = this.table.getSelectedRow();
        if (cnt == 0) {
            this.resetButton.setEnabled(false);
        } else {
            this.resetButton.setEnabled(true);
        }
        if (row > -1) {
            return;
        }
        this.table.requestFocusInWindow();
        this.table.clearSelection();
        this.table.changeSelection(0, 0, false, false);
    }

    public void valueChanged(ListSelectionEvent e) {
        selectedIndex = this.table.getSelectedRow();
    }

    private void createComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(LanguageFactory.get_text("menu-file", new String[0]));
        this.helpMenu = new JMenu(LanguageFactory.get_text("menu-help", new String[0]));
        this.exitMenuItem = new JMenuItem(new ExitAction(this));
        this.aboutMenuItem = new JMenuItem(LanguageFactory.get_text("menu-about", this.props.getProperty("caption")));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Main.this, LanguageFactory.get_text("aboutdlg-text", Main.this.props.getProperty("caption"), Main.this.props.getProperty("version"), Main.this.props.getProperty("build")), LanguageFactory.get_text("aboutdlg-caption", Main.this.props.getProperty("caption")), 1);
            }
        });
        this.noteMenuItem = new JMenuItem(LanguageFactory.get_text("menu-readme", new String[0]));
        this.noteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Main.this, LanguageFactory.get_text("readmedlg-text", new String[0]), LanguageFactory.get_text("readmedlg-caption", new String[0]), 1);
            }
        });
        this.localeMenu = new JMenu(LanguageFactory.get_text("menu-language", new String[0]));
        String[] language_res = null;
        try {
            language_res = this.getResourceListing(this.getClass(), "languages/");
        }
        catch (URISyntaxException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        Pattern p = Pattern.compile("locale_(\\w+).properties");
        for (int i = 0; i < language_res.length; ++i) {
            Properties lang_props = new Properties();
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                InputStream is = classLoader.getResourceAsStream("languages/" + language_res[i]);
                InputStreamReader ir = new InputStreamReader(is, "UTF-8");
                lang_props.load(ir);
            }
            catch (IOException e) {
                System.out.println("Properties file not found");
            }
            Matcher m = p.matcher(language_res[i]);
            if (!m.matches()) continue;
            String lang_title = lang_props.getProperty("language");
            final String lang_id = m.group(1);
            JMenuItem language_item = new JMenuItem(lang_title);
            language_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguageFactory.load(lang_id);
                    Main.this.renewTitles();
                }
            });
            this.localeMenu.add(language_item);
        }
        this.model = new DeviceTableModel();
        this.model.addTableModelListener(this);
        this.table = new JTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.getResetHolder().addListener(this.model);
        this.getResetHolder().addListener(this);
        this.getDiscoveryHolder().addListener(this.model);
        this.getDiscoveryHolder().addListener(this);
        this.table.setSelectionMode(0);
        this.table.setFont(new Font("Monospaced", 0, 12));
        this.statusBar = new StatusBar();
        this.setStatus(LanguageFactory.get_text("status-ready", new String[0]));
        final DiscoveryActionHandler discovery_hndl = new DiscoveryActionHandler(this);
        final ResetActionHandler reset_hndl = new ResetActionHandler(this);
        this.getResetHolder().addListener(discovery_hndl);
        this.getResetHolder().addListener(reset_hndl);
        this.getDiscoveryHolder().addListener(discovery_hndl);
        this.getDiscoveryHolder().addListener(reset_hndl);
        this.discoveryButton = new JButton(LanguageFactory.get_text("button-scan", new String[0]));
        this.discoveryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread thr = new Thread(discovery_hndl);
                thr.start();
            }
        });
        this.resetButton = new JButton(LanguageFactory.get_text("button-reset", new String[0]));
        ActionListener resetAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.this.getResetHolder().get_proto_ver() == 2) {
                    Thread thr = new Thread(reset_hndl);
                    thr.start();
                } else {
                    index = 0;
                    Thread thr = new Thread(reset_hndl);
                    thr.start();
                    Main.this.setStatus("");
                    Main.this.setHint("");
                    Main.this.setDevice("");
                }
            }
        };
        this.resetButton.setEnabled(false);
        this.resetButton.addActionListener(resetAL);
        this.clearButton = new JButton(LanguageFactory.get_text("button-clear", new String[0]));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (index > 0) {
                    if (Main.this.ext_mac != null) {
                        Main.this.getResetHolder().send_boot(Main.this.ext_mac);
                    } else {
                        System.out.println("extdev mac not found, cannot speedup boot");
                    }
                    Main.this.ext_mac = null;
                }
                index = 0;
                Main.this.setStatus("");
                Main.this.setHint("");
                Main.this.setDevice("");
                Main.this.clearDevices();
            }
        });
        this.addButton = new JButton(LanguageFactory.get_text("button-add", new String[0]));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewDeviceDialog dd = new NewDeviceDialog(Main.this.self);
                dd.setVisible(true);
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(LanguageFactory.get_text("button-launch", new String[0]));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = Main.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                String wiliIp = Main.this.table.getValueAt(row, 0).toString();
                Main.launchBrowser(wiliIp);
            }
        });
        this.popupMenu.add(item);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = Main.this.table.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    String wiliIp = Main.this.table.getValueAt(row, 0).toString();
                    Main.launchBrowser(wiliIp);
                }
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = Main.this.table.rowAtPoint(e.getPoint());
                    Main.this.table.getSelectionModel().setSelectionInterval(row, row);
                    Main.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected static void launchBrowser(String ip) {
        String os = System.getProperty("os.name");
        String[] exec = null;
        if (exec == null) {
            exec = "linux".equalsIgnoreCase(os) ? LINUX_BROWSER : (os != null && os.startsWith("Mac") ? MACOSX_BROWSER : WIN32_BROWSER);
        }
        String[] cmd = new String[exec.length];
        for (int i = 0; i < exec.length; ++i) {
            String string = "http://" + ip;
            cmd[i] = MessageFormat.format(exec[i], string);
        }
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void layoutComponents() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.helpMenu);
        this.menuBar.add(this.localeMenu);
        this.fileMenu.add(this.exitMenuItem);
        this.helpMenu.add(this.noteMenuItem);
        this.helpMenu.add(this.aboutMenuItem);
        this.setJMenuBar(this.menuBar);
        JPanel scanCntrlPanel = new JPanel();
        scanCntrlPanel.setLayout(new BoxLayout(scanCntrlPanel, 2));
        scanCntrlPanel.add(this.discoveryButton);
        scanCntrlPanel.add(this.clearButton);
        scanCntrlPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        scanCntrlPanel.add(this.addButton);
        scanCntrlPanel.add(Box.createHorizontalGlue());
        scanCntrlPanel.add(this.resetButton);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(80);
        col = this.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(80);
        col = this.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(500);
        col = this.table.getColumnModel().getColumn(3);
        col.setPreferredWidth(20);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel scanPanel = new JPanel(new BorderLayout());
        scanPanel.add((Component)tablePanel, "Center");
        scanPanel.add((Component)scanCntrlPanel, "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scanPanel, "Center");
        mainPanel.add((Component)this.statusBar, "South");
        this.setContentPane(mainPanel);
    }

    public void setStatus(String msg) {
        this.statusBar.setText(msg);
        this.statusBar.setHint("");
    }

    public void setHint(String hint) {
        this.statusBar.setHint(hint);
    }

    public void setDevice(String dev) {
        this.statusBar.setDevice(dev);
    }

    public static boolean get_verbose() {
        return verbose;
    }

    public static void silent_on() {
        silent = true;
    }

    public static void silent_off() {
        silent = false;
    }

    String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static void perror(String msg) {
        if (Shell.isWindows()) {
            System.out.println(msg);
        } else {
            System.err.println(msg);
        }
    }

    public static void die(String msg) {
        Main.perror(msg);
        System.exit(1);
    }

    public static Properties getToolInfo() {
        Properties p = new Properties();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            p.load(classLoader.getResourceAsStream("project.properties"));
        }
        catch (IOException e) {
            Main.die("Properties file not found");
        }
        return p;
    }

    public static void main(String[] args) {
        int c;
        int verbosity = 0;
        Properties toolProps = Main.getToolInfo();
        LanguageFactory.load(toolProps.getProperty("language"));
        GetOpt g = new GetOpt(args, "v");
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 118: {
                    ++verbosity;
                }
            }
        }
        if (Shell.isWindows()) {
            try {
                WindowsShell.updateFirewallRules();
            }
            catch (IOException e) {
                Main.perror("updateFirewallRules() excaption cought: " + e.getMessage());
                JOptionPane.showMessageDialog(null, LanguageFactory.get_text("failed.auto.firewall.rules.add.text", new String[0]), LanguageFactory.get_text("failed.auto.firewall.rules.add.caption", new String[0]), 0);
            }
        }
        DiscoveryProto discovery = null;
        LegacyProto legacy = null;
        try {
            discovery = new DiscoveryProto(verbosity);
            legacy = new LegacyProto(verbosity);
        }
        catch (ProtocolException e) {
            JOptionPane.showMessageDialog(null, LanguageFactory.get_text("failed.network.sockets.open.text", new String[0]), LanguageFactory.get_text("failed.network.sockets.open.caption", new String[0]), 0);
            Main.die("Can't start reader threads");
        }
        new Main(toolProps, verbosity, legacy, discovery);
    }

    static {
        System.setProperty("file.encoding", "UTF-8");
        WIN32_BROWSER = new String[]{"cmd.exe", "/C", "\"start {0}\""};
        LINUX_BROWSER = new String[]{"sensible-browser", "{0}"};
        MACOSX_BROWSER = new String[]{"open", "{0}"};
        dList = new LinkedList();
        index = 0;
        selectedIndex = -1;
        silent = false;
        verbose = false;
    }
}

