/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.DiscoveryProtoListener;
import com.wilibox.discovery.LegacyInfoResponse;
import com.wilibox.discovery.LegacyRequest;
import com.wilibox.discovery.LegacyResponse;
import com.wilibox.discovery.MulticastQueryServer;
import com.wilibox.discovery.PacketDump;
import com.wilibox.discovery.ProtocolException;
import com.wilibox.discovery.SocketInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class LegacyProto
implements Runnable {
    private static final Logger logger = Logger.getLogger(LegacyProto.class.getName());
    private static boolean verbose = false;
    private static final byte[] MULTICAST_ADDR = new byte[]{-23, 89, -68, 1};
    private static final int MULTICAST_PORT = 10001;
    private static final byte PROTO_VERSION = 0;
    private static final byte PROTO_CMD_DISCOVERY = 0;
    private static final byte PROTO_CMD_WNMS_HB = 1;
    private static final int OUTPUT_BUFFER_SIZE = 255;
    private static byte[] output_buffer = new byte[255];
    protected EventListenerList listenerList = new EventListenerList();
    private Thread readerThread;
    private MulticastQueryServer server;

    public LegacyProto(int verbosity) throws ProtocolException {
        boolean bl = verbose = verbosity != 0;
        if (verbose) {
            logger.setLevel(Level.ALL);
        }
        logger.log(Level.FINE, "Initializing Legacy Discovery protocol");
        this.server = new MulticastQueryServer(MULTICAST_ADDR, 10001);
        if (verbose) {
            this.server.setVerbose();
        }
        if (this.server.create_legacy_sockets() != 0) {
            throw new ProtocolException("Failed discovery (v0) protocol sockets create");
        }
        this.readerThread = new Thread(this);
        this.readerThread.start();
    }

    public MulticastQueryServer getServer() {
        return this.server;
    }

    public int send(byte[] data, int size) {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(MULTICAST_ADDR);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Multicast address cast failed", e);
            return -1;
        }
        DatagramPacket packet = new DatagramPacket(data, size, addr, 10001);
        int status = this.server.write_sockets(packet);
        if (status == 0) {
            this.readerThread.interrupt();
        }
        return status;
    }

    public int send_discovery() {
        int size = LegacyRequest.to_array(output_buffer);
        return this.send(output_buffer, size);
    }

    public int parse_packet(DatagramPacket packet, SocketInfo sinfo) {
        String sender = packet.getAddress().getHostAddress();
        String iface = sinfo.getInterface();
        try {
            LegacyResponse legacy_packet = new LegacyResponse(packet);
            if (legacy_packet.no_data()) {
                logger.log(Level.INFO, "Received loopback multicast packet");
                return 1;
            }
            if (legacy_packet.get_version() != 0) {
                logger.log(Level.INFO, "Received unknonwn multicast response: {0}", legacy_packet.get_version());
                return 2;
            }
            if (legacy_packet.get_cmd() != 0) {
                logger.log(Level.WARNING, "Received unknown command ({0}) from {1}", new Object[]{legacy_packet.get_cmd(), sender});
                if (verbose) {
                    PacketDump.dump(packet);
                }
                return 0;
            }
            LegacyInfoResponse info_packet = new LegacyInfoResponse(legacy_packet);
            Device dev = new Device(info_packet.get_mac(), InetAddress.getByName(info_packet.get_ip()), info_packet.get_firmware(), sender, sinfo);
            this.fireDiscoveredDevice(dev);
            return 0;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Parse error, dropping packet");
            if (verbose) {
                System.out.println("Packed received via " + iface);
                PacketDump.dump(packet);
            }
            return -1;
        }
    }

    public void run() {
        DatagramPacket packet = new DatagramPacket(new byte[1500], 1500);
        SocketInfo sinfo = new SocketInfo();
        while (true) {
            int status;
            if ((status = this.server.read_sockets(packet, sinfo)) == 0) {
                this.parse_packet(packet, sinfo);
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void addListener(DiscoveryProtoListener l) {
        this.listenerList.add(DiscoveryProtoListener.class, l);
    }

    public void removeListener(DiscoveryProtoListener l) {
        this.listenerList.remove(DiscoveryProtoListener.class, l);
    }

    protected void fireDiscoveredDevice(Device dev) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiscoveryProtoListener.class) continue;
            DiscoveryProtoListener l = (DiscoveryProtoListener)listeners[i + 1];
            l.deviceFound(dev);
        }
    }
}

