/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Utf8ResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LanguageFactory {
    public static ResourceBundle rb = ResourceBundle.getBundle("languages.locale_en");

    public static void load(String value) {
        Locale l = new Locale(value);
        Locale.setDefault(l);
        ResourceBundle.clearCache();
        try {
            rb = Utf8ResourceBundle.getBundle("languages.locale", l);
        }
        catch (MissingResourceException e) {
            if (value.equals("EN")) {
                return;
            }
            System.err.println("Locale " + value + " not found. Using english");
            LanguageFactory.load("EN");
        }
    }

    public static Locale get_locale() {
        return Locale.getDefault();
    }

    public static String get_text(String name, String ... args) {
        String line = "";
        try {
            line = rb.getString(name);
            return String.format(LanguageFactory.get_locale(), line, (Object[])args);
        }
        catch (MissingResourceException missingResourceException) {
            return line;
        }
    }
}

