/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.DiscoveryProtoListener;
import com.wilibox.discovery.LanguageFactory;
import javax.swing.table.DefaultTableModel;

public class DeviceTableModel
extends DefaultTableModel
implements DiscoveryProtoListener {
    public DeviceTableModel() {
        super(0, 3);
        this.refreshTitles();
    }

    public final void refreshTitles() {
        this.setColumnIdentifiers(new Object[]{LanguageFactory.get_text("table-ip", new String[0]), LanguageFactory.get_text("table-mac", new String[0]), LanguageFactory.get_text("table-firmware", new String[0]), LanguageFactory.get_text("table-interface", new String[0])});
    }

    public void deviceFound(Device dev) {
        Object[] rowData = new Object[]{dev.getWiliIpAddress(), dev.getMacAddress(), dev.getFirmwareVersion(), dev.getInterface()};
        int row = -1;
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String mac = (String)this.getValueAt(i, 1);
            if (!mac.equals(dev.getMacAddress())) continue;
            row = i;
            for (int j = 0; j < rowData.length; ++j) {
                this.setValueAt(rowData[j], row, j);
            }
            break;
        }
        if (row == -1) {
            this.addRow(rowData);
        } else {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public void addRow(Device dev) {
        Object[] rowData = new Object[]{dev.getWiliIpAddress(), dev.getMacAddress(), dev.getFirmwareVersion(), dev.getInterface()};
        this.addRow(rowData);
    }

    public void updateRow(Device dev) {
    }

    public void deviceBootState(String mac) {
    }

    public void deviceWorkState(String mac) {
    }

    public void deviceExtended(String mac) {
    }

    public void deviceReseting(String mac) {
    }

    public void deviceMarked(String mac) {
    }

    public void deviceWrongPin(String mac) {
    }

    public void clear() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.removeRow(i);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

