/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import java.util.Random;

public class BinUtils {
    public static final byte BYTE = -1;
    public static final byte BITS = 8;
    static final String HEXES = "0123456789ABCDEF";

    private static void data_to_arr(byte[] arr, long num, int data_size) throws IllegalArgumentException {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        if (arr.length < data_size) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < data_size; ++i) {
            byte shift = (byte)(i * 8);
            arr[data_size - 1 - i] = (byte)(num >>> shift);
        }
    }

    public static void byte_to_arr(byte[] arr, byte num) throws IllegalArgumentException {
        BinUtils.data_to_arr(arr, num, 1);
    }

    public static void short_to_arr(byte[] arr, short num) throws IllegalArgumentException {
        BinUtils.data_to_arr(arr, num, 2);
    }

    public static void int_to_arr(byte[] arr, int num) throws IllegalArgumentException {
        BinUtils.data_to_arr(arr, num, 4);
    }

    public static void long_to_arr(byte[] arr, long num) throws IllegalArgumentException {
        BinUtils.data_to_arr(arr, num, 8);
    }

    public static short arr_to_short(byte[] arr) throws IllegalArgumentException {
        return (short)BinUtils.arr_to_long(arr);
    }

    public static int arr_to_int(byte[] arr) throws IllegalArgumentException {
        return (int)BinUtils.arr_to_long(arr);
    }

    public static long arr_to_long(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        for (int i = 0; i < arr.length; ++i) {
            l <<= 8;
            l ^= (long)arr[i] & 0xFFL;
        }
        return l;
    }

    private static String get_hex(long num, int data_size) {
        byte[] x = new byte[data_size];
        BinUtils.data_to_arr(x, num, data_size);
        return BinUtils.get_hex(x);
    }

    public static String get_hex(byte num) {
        StringBuilder hex = new StringBuilder(4);
        hex.append(HEXES.charAt((num & 0xF0) >> 4)).append(HEXES.charAt(num & 0xF));
        return hex.toString();
    }

    public static String get_hex(short num) throws IllegalArgumentException {
        return BinUtils.get_hex(num, 2);
    }

    public static String get_hex(int num) throws IllegalArgumentException {
        return BinUtils.get_hex(num, 4);
    }

    public static String get_hex(long num) throws IllegalArgumentException {
        return BinUtils.get_hex(num, 8);
    }

    public static String get_hex(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        String line = "";
        for (int i = 0; i < arr.length; ++i) {
            line = line + BinUtils.get_hex(arr[i]) + " ";
        }
        return line;
    }

    private static void extend_arr(byte[] arr, int offset, long num, int data_size) throws IllegalArgumentException {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        byte[] x = new byte[data_size];
        BinUtils.data_to_arr(x, num, data_size);
        BinUtils.extend_arr(arr, offset, x);
    }

    public static void extend_arr(byte[] arr, int offset, byte num) throws IllegalArgumentException {
        BinUtils.extend_arr(arr, offset, num, 1);
    }

    public static void extend_arr(byte[] arr, int offset, short num) throws IllegalArgumentException {
        BinUtils.extend_arr(arr, offset, num, 2);
    }

    public static void extend_arr(byte[] arr, int offset, int num) throws IllegalArgumentException {
        BinUtils.extend_arr(arr, offset, num, 4);
    }

    public static void extend_arr(byte[] arr, int offset, long num) throws IllegalArgumentException {
        BinUtils.extend_arr(arr, offset, num, 8);
    }

    public static void extend_arr(byte[] arr, int offset, byte[] src) throws IllegalArgumentException {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        if (arr.length < src.length + offset) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < src.length; ++i) {
            arr[i + offset] = src[i];
        }
    }

    public static byte[] mac_to_arr(String mac) {
        byte[] marr = new byte[6];
        String[] mac_domens = mac.split("-");
        for (int i = 0; i < mac_domens.length; ++i) {
            marr[i] = (byte)Integer.valueOf(mac_domens[i], 16).intValue();
        }
        return marr;
    }

    public static String arr_to_mac(byte[] arr) throws IllegalArgumentException {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        if (arr.length != 6) {
            throw new IllegalArgumentException();
        }
        String mac = BinUtils.get_hex(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            mac = mac + "-" + BinUtils.get_hex(arr[i]);
        }
        return mac;
    }

    public static long mac_to_long(String mac) {
        byte[] data = BinUtils.mac_to_arr(mac);
        long lmac = BinUtils.arr_to_long(data);
        return lmac;
    }

    public static String long_to_mac(long mac) {
        byte[] data = new byte[8];
        BinUtils.long_to_arr(data, mac);
        byte[] data2 = new byte[6];
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = data[i + 2];
        }
        String smac = BinUtils.arr_to_mac(data2);
        return smac;
    }

    public static void random_long_arr(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException();
        }
        Random generator = new Random();
        generator.nextBytes(arr);
    }

    public static long random_long() {
        Random generator = new Random();
        return generator.nextLong();
    }
}

