/*
 * Decompiled with CFR 0.152.
 */
package com.wilibox.discovery;

import com.wilibox.discovery.Device;
import com.wilibox.discovery.LanguageFactory;
import com.wilibox.discovery.Main;
import com.wilibox.discovery.PinDialog;
import com.wilibox.discovery.ResetAction;
import com.wilibox.discovery.ResetActionHandler;

class AtherosResetAction
extends ResetAction {
    private ResetActionHandler parent;
    private Main main;
    private Device reset_device;
    private PinDialog pd;
    private String pin = "";
    private int state_counter;
    private static final int ST_UNKNOWN = 0;
    private static final int ST_BOOTING = 3;
    private static final int ST_EXTENDED = 7;
    private static final int ST_RESETING = 15;
    private static final int ST_RESETED = 31;
    private static final int ST_READY = 63;
    private static final int ST_WRONGPIN = 103;
    private static final int ST_USERSTOP = 65535;

    private String strState(int state) {
        switch (state) {
            case 0: {
                return "Unknown";
            }
            case 3: {
                return "Booting";
            }
            case 7: {
                return "Extended";
            }
            case 15: {
                return "Reseting";
            }
            case 31: {
                return "Reseted";
            }
            case 63: {
                return "Ready";
            }
            case 65535: {
                return "UserStop";
            }
            case 103: {
                return "WrongPin";
            }
        }
        return "";
    }

    public AtherosResetAction(ResetActionHandler parent, Device reset_device, Main main) {
        this.parent = parent;
        this.main = main;
        this.reset_device = reset_device;
    }

    public void deviceBootState(String mac) {
        this.state_counter = this.state_counter == 15 ? (this.state_counter |= 0x1F) : (this.state_counter |= 3);
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceWorkState(String mac) {
        this.state_counter |= 0x3F;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceExtended(String mac) {
        this.state_counter |= 7;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceReseting(String mac) {
        this.state_counter |= 0xF;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void deviceWrongPin(String mac) {
        this.state_counter = 103;
        System.out.print("Reset state: " + this.strState(this.state_counter) + " - ");
        System.out.println(this.state_counter);
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.state_counter = 65535;
    }

    public boolean is_canceled() {
        return this.state_counter == 65535;
    }

    public void run() {
        this.state_counter = 0;
        String device_mac = this.reset_device.getMacAddress();
        this.mcast_reset(device_mac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcast_reset(String devMac) {
        try {
            this.parent.setStatus(LanguageFactory.get_text("status-devstate", new String[0]));
            this.parent.setHint("");
            this.parent.getResetHolder().send_state(devMac);
            this.sleep(1000);
            this.parent.setStatus(LanguageFactory.get_text("status-booting", new String[0]));
            this.parent.setHint("");
            while (this.state_counter < 3) {
                this.sleep(1000);
            }
            this.parent.setStatus(LanguageFactory.get_text("status-extending", new String[0]));
            this.parent.setHint("");
            int counter = 0;
            while (this.state_counter < 7) {
                this.sleep(1000);
                if (counter > 5) {
                    this.parent.setHint(LanguageFactory.get_text("reset-hint-onoff-again", new String[0]));
                }
                ++counter;
            }
            this.parent.setStatus(LanguageFactory.get_text("status-extended", new String[0]));
            this.parent.setHint("");
            this.pd = new PinDialog(this.main);
            Thread thr = new Thread(new Runnable(){

                public void run() {
                    while (AtherosResetAction.this.main.getIndex() > 0) {
                        AtherosResetAction.this.sleep(1000);
                        if (AtherosResetAction.this.main.getIndex() != 0) continue;
                        AtherosResetAction.this.pd.dispose();
                    }
                }
            });
            thr.start();
            this.pd.setVisible(true);
            this.pin = this.pd.getPin();
            this.main.setIndex(0);
            this.main.setHint("");
            this.main.setStatus("");
            this.main.setDevice("");
            this.parent.setStatus(LanguageFactory.get_text("pindlg-chk-pin", new String[0]));
            this.parent.setHint("");
            this.parent.getResetHolder().send_pin(devMac, this.pin);
            this.sleep(1000);
            this.parent.setStatus(LanguageFactory.get_text("status-reseting", new String[0]));
            this.parent.setHint("");
            counter = 0;
            while (this.state_counter < 15) {
                this.sleep(1000);
                if (counter > 10) {
                    this.parent.setHint(LanguageFactory.get_text("reset-hint-onoff-again", new String[0]));
                }
                ++counter;
            }
            this.parent.getResetHolder().set_autoextend(false);
            while (this.state_counter < 31) {
                this.sleep(1000);
            }
            this.parent.setStatus(LanguageFactory.get_text("status-booting", new String[0]));
            if (this.state_counter == 103) {
                this.parent.setHint(LanguageFactory.get_text("status-wrongpin", new String[0]));
            } else {
                this.parent.setHint("");
            }
            this.sleep(15000);
            if (this.state_counter == 103) {
                this.parent.reset_finish(LanguageFactory.get_text("status-failed", new String[0]), LanguageFactory.get_text("status-wrongpin", new String[0]));
            } else {
                this.parent.reset_finish(LanguageFactory.get_text("status-complete", new String[0]), "");
            }
        }
        catch (Exception ex) {
            if (this.parent.is_verbose()) {
                ex.printStackTrace();
            }
            this.parent.reset_finish(LanguageFactory.get_text("status-failed", new String[0]), ex.getMessage());
        }
        finally {
            this.parent.getResetHolder().set_autoextend(true);
        }
    }
}

